const network = require("network");
const chalk = require("chalk");
const gatewayDAO = require("../database/models/DAO/gateway.dao");
const Gateway = require("../database/models/gateway.model");
const CronJob = require("node-schedule");
const temp = require("./src/temp");
const uuidv4 = require("uuid/v4");
const messagesProcessor = require("./src/services/processor.gatewayStatus");
const bonjour = require("bonjour")()
const os = require('os');

const res = init();
var gpioControl = require('../system-on-module/gpioController');

async function init() {
  network.get_active_interface(async function (err, obj) {
    var data;
    var status;
    if (obj) {
      status = "NETWORK STATUS OK";
      data = {
        ipV4: {
          address: obj.ip_address,
          mask: obj.netmask,
          gateway: obj.gateway_ip
        }
      };
    } else {
      status = "ERROR: NO NETWORK CONNECTION";
      data = {
        ipV4: {
          address: "",
          mask: "",
          gateway: ""
        }
      };
    }
    console.log(chalk.blue("[index] [network] " + status));
    console.log(chalk.blue("[index] [network] " + JSON.stringify(data.ipV4)));
    var aux = (data) ? gpioControl.setLed(2, 1, 1, 0) : gpioControl.setLed(2, 0, 1, 0);

    var gateway = await Gateway.findOne({});

    if (gateway) {
      await initialize(gateway, data);
    } else {
      const gtw = await temp.create(data);
      await initialize(gtw, data);
    }
  });
}

async function initialize(gateway, data) {
  bonjour.find({ name: 'cap-ecomfort-request' }, async function (service) {
    // console.log('[bonjour] Nova fonte encontrada: ', service.txt);                
    try {
      if (service.txt.findgatewaypixel === gateway.serialNumber) {
        // console.log("[bonjour] Fonte aceita. Publicado:");                                       
        //let code = Math.random().toString(16).substr(2);                               
        let advertisement = bonjour.publish({
          name: 'cap-ecomfort-response-' + uuidv4(),
          type: 'http',
          host: os.hostname() + '.local',
          protocol: 'tcp',
          port: 3010,
          txt: { findGatewayPixel: "OK(" + gateway.serialNumber + ")", ipV4: data.ipV4.address }
        })
          .on('up', res => console.log(chalk.green("[bonjour] Publishing: ", gateway.serialNumber, data.ipV4.address)))
          .on('error', err => console.log("[bonjour] Error", err))

        setTimeout(() => {
          advertisement.stop(() => console.log('[bonjour] Unpublishing'))
          bonjour.unpublishAll()
        }, 1000)
      }
    } catch (error) {
      console.log("[bonjour] [error] ", error);
    }
  });
  //var cron = new CronJob.scheduleJob("*/1 * * * *", function() {
  //  bonjour.unpublishAll();
  //});

  gatewayDAO.updateGateway(gateway._id, data).then(function (callback) {
    require("./src/shepherd/zs-shepherd");
    require("./src/mqtt/brokerClient");
    require("./src/cronJobs/rulesCron.services").resetJobs()
  });
}
