const Document = require("camo").Document;
const uuidv4 = require('uuid/v4');

class Environment extends Document {
  constructor() {
    super();

    this.environmentId = {
      type: String,
      default: uuidv4()
    };
    this.name = String;
    this.devices = [Object];
    this.created = {
      type: Date,
      default: Date.now
    };
    this.lastUpdate = {
      type: Date,
      default: Date.now
    };
  }

  static collectionName() {
    return "environments";
  }
}

var environment = Environment;

module.exports = environment;
