const Document = require("camo").Document;

class Device extends Document {
  constructor() {
    super();

    this.name = String;
    this.ieeeAddr = String;
    this.epList = [Number];
    this.nwkAddr = Number;
    this.profId = String;
    this.devId = String;
    this.modelId = String;
    this.status = String;
    this.manufId = String;
    this.manufName = String;
    this.powerSource = String;
    this.type = String;
    this.environment = {
      type: Object,
      default: {}
    };
    this.clusters = {
      type: Object,
      default: {}
    };
    this.blocked = {
      type: Boolean,
      default: false
    };
    this.isActive = {
      type: Boolean,
      default: true
    };
    this.created = {
      type: Date,
      default: Date.now
    };
    this.lastUpdate = {
      type: Date,
      default: Date.now
    };
    this.inClusterList = [Number];
    this.outClusterList = [Number];
    this.lastReport = {
      type: Date,
      default: Date.now
    }
  }

  static collectionName() {
    return "devices";
  }

}


var device = Device;

module.exports = device;

