"use strict";

const BlackList = require("../user.blackList.model");

exports.findBlackList = async data => {
    let blacklist = await BlackList.findOne({ email: data.email });
    return dataAdjust(blacklist);
};

exports.listBlackList = async () => BlackList.find();

exports.createBlackList = async data => {
    var blacklist = await BlackList.create(data);
    await blacklist.save();
    return dataAdjust(blacklist);
};

exports.updateBlackList = async (data) => {
    var blacklist = await BlackList.findOneAndUpdate(
        { email: data.email },
        data,
        { multi: false },
        function (err, numReplaced) { }
    );
    blacklist.lastUpdate = Date.now();
    await blacklist.save();
    return dataAdjust(blacklist);
};

exports.deleteBlackList = async param => {
    return await BlackList.findOneAndDelete({ email: param.email });
};

exports.deleteAllBlackList = async () => {
    return await BlackList.deleteMany({});
};

function dataAdjust(data) {
    return {
        email: data.email,
        blackListDevice: data.blackListDevice,
        blackListScenario: data.blackListScenario,
        blackListEnvironment: data.blackListEnvironment
    }
}