"use strict";

const Access = require("../user.access.model");

exports.findAccess = async data => {
    let access = await Access.findOne({ email: data.email });
    return dataAdjust(access);
};

exports.listAccess = async () => {
    let accesss = await Access.find();

    var acs = [];

    accesss.forEach(async access => {
        acs.push(dataAdjust(access));
    });

    return acs;
}

exports.createAccess = async data => {
    var access = await Access.create(data);
    await access.save();
    return dataAdjust(access);
};

exports.updateAccess = async (data) => {
    var access = await Access.findOneAndUpdate(
        { email: data.email },
        data,
        { multi: false },
        function (err, numReplaced) { }
    );
    access.lastUpdate = Date.now();
    await access.save();
    return dataAdjust(access);
};

exports.deleteAccess = async param => {
    return await Access.findOneAndDelete({ email: param.email });
};

exports.deleteAllAccess = async () => {
    return await Access.deleteMany({});
};

function dataAdjust(data) {
    return {
        email: data.email,
        role: data.role,
        token: data.token
    }
}