"use strict";

const chalk = require("chalk");
const Scenario = require("../scenario.model");

exports.listScenarioById = async scenarioId => {
  let scenario = await Scenario.findOne({ scenarioId: scenarioId });
  if (scenario) {
    return dataAdjust(scenario);
  }else{
    return null;
  }
}

exports.listScenarios = async data => {
  let scenarios = await Scenario.find();
  return scenarios;
};

exports.createScenario = async data => {
  let scenario = await Scenario.create(data);
  await scenario.save();
  console.log(chalk.green("[nedb-scenario] [create] " + data.scenarioId + ": " + JSON.stringify(data)));
  return dataAdjust(scenario);
};


exports.updateScenario = async (param, data) => {
  let scenario = await Scenario.findOneAndUpdate(
    { scenarioId: param.scenarioId },
    data
  );
  scenario.lastUpdate = Date.now();
  await scenario.save();
  
  console.log(chalk.green("[nedb-scenario] [update]" + data.scenarioId + ": " + JSON.stringify(data)));
  return dataAdjust(scenario);
};

exports.deleteScenario = async scenarioId => {
  console.log(chalk.green("[nedb-scenario] [delete]" + scenarioId + ": deleted"));
  return await Scenario.findOneAndDelete({ scenarioId: scenarioId });
};

exports.deleteAllScenario = async () => {
  return await Scenario.deleteMany({});
};

function dataAdjust(data) {
  return {
    name: data.name,
    scenarioId: data.scenarioId,
    actions: data.actions
  }
}