"use strict";

const Rule = require("../rule.model");
const chalk = require("chalk");
const _ = require("lodash");

exports.listRuleById = async data => await Rule.findOne({ ruleId: data.ruleId });

exports.listRules = async () => {
  let rules = await Rule.find();
  return rules;
};

exports.createRule = async data => {
  let rule = await Rule.create(data);
  await rule.save();
  console.log(chalk.green("[nedb-rule] [create] " + rule.ruleId + ": " + JSON.stringify(data)));
  
  return dataAdjust(rule);
};

exports.updateRule = async (ruleId, data) => {
  let rule = await Rule.findOneAndUpdate({ ruleId: ruleId }, data);
  rule.lastUpdate = Date.now();
  await rule.save();
  console.log(chalk.green("[nedb-rule] [update] " + ruleId + ": " + JSON.stringify(data)));
  return dataAdjust(rule);
};

exports.deleteRule = async ruleId => {
  const res = await Rule.findOneAndDelete({ ruleId: ruleId });
  console.log(chalk.green("[nedb-rule] [delete] " + ruleId + ": deleted"));
  return res;
};

exports.deleteAllRules = async () => {
  return await Rule.deleteMany({});
};

function dataAdjust(data) {
  return {
    ruleId: data.ruleId,
    name: data.name,
    inputs: data.inputs,
    outputs: data.outputs,
    sceneOutputs: data.sceneOutputs,
    schedule: data.schedule,
    isActive: data.isActive
  }
}