const chalk = require("chalk");
const Gateway = require("../gateway.model");
// Used on general status:
const deviceDAO = require("./device.dao");
const environmentDAO = require("./environment.dao");
const scenarioDAO = require("./scenario.dao");
const ruleDAO = require("./rule.dao");


module.exports.updateGatewaySerial = updateGatewaySerial;

exports.finGateway = async data => {
  let gateways = await Gateway.find();
  return gateways;
};

exports.listGateway = async () => Gateway.find();

exports.createGateway = async data => {
  var gateway = await Gateway.create(data);
  await gateway.save();

  console.log(chalk.green("[nedb-gateway] [create] " + gateway._id + ": " + JSON.stringify(dataAdjust(gateway))));
  return dataAdjust(gateway);
};

exports.updateGateway = async (gatewayId, data) => {
  var gateway = await Gateway.findOneAndUpdate(
    { _id: gatewayId },
    data,
    { multi: false },
    function (err, numReplaced) { }
  );
  gateway.lastUpdate = Date.now();
  await gateway.save();
  console.log(chalk.green("[nedb-gateway] [update] " + gatewayId + ": " + JSON.stringify(data)));
  return gateway;
};

async function updateGatewaySerial(data) {
  var gateway = await Gateway.findOneAndUpdate(
    { },
    data,
    { multi: false },
    function (err, numReplaced) { }
  );
  gateway.lastUpdate = Date.now();
  await gateway.save();
  console.log(chalk.green("[nedb-gateway] [update]: " + JSON.stringify(data)));
  return gateway;
};

exports.deleteGateway = async param => {
  console.log(chalk.green("[nedb-gateway] [delete] " + param.gatewayId + ": deleted"));
  return await Gateway.findOneAndDelete({ _id: param.gatewayId });
};

function dataAdjust(data) {
  return {
    _id : data._id,
    name : data.name,
    ipV4 : data.ipV4,
    timezone: data.timezone,
    hwVersion : data.hwVersion,
    fwVersion : data.fwVersion,
    panId: data.panId,
    status : data.status,
    serialNumber : data.serialNumber,
  }
}

exports.getGeneralStatus = async () => {
  const gateway = await Gateway.findOne({ status: "active" });
  if (gateway) {
    const data = {
      ipV4: await gateway.ipV4,
      name: await gateway.name,
      serialNumber: await gateway.serialNumber,
      timezone: await gateway.timezone,
      devices: await deviceDAO.listDevicesMqtt(),
      environments: await environmentDAO.listEnvironments(),
      scenarios: await scenarioDAO.listScenarios(),
      rules: await ruleDAO.listRules()
    };
    const result = await {
      topic: "status",
      operation: "report",
      data: await data
    };
    return result;
  }
  return null
}
