"use strict";

const chalk = require("chalk");
const Environment = require("../environment.model");
const uuidv4 = require("uuid/v4");

exports.listEnvironmentById = async data =>
  await Environment.findOne({ environmentId: data.environmentId });

exports.listEnvironmentByName = async data =>
  await Environment.findOne({ name: data.name });

exports.listEnvironments = async data => {
  let environments = await Environment.find();
  return environments;
};

exports.getEnvironmentWithDevice = async data => {
  let environments = await Environment.find();
  
  console.log("1: ",data);
  console.log("2: ", environments);
  return environments;
};

exports.createEnvironment = async data => {
  data.environmentId = data.environmentId ? data.environmentId : uuidv4();
  let environment = await Environment.create(data);
  await environment.save();
  
  console.log(chalk.green("[nedb-environment] [create] " + environment.environmentId + ": " + JSON.stringify(data)));
  return dataAdjust(environment);
};

exports.updateEnvironment = async (envId, data) => {
  let environment = await Environment.findOneAndUpdate(
    { environmentId: envId.environmentId },
    data
  );
  environment.lastUpdate = Date.now();
  await environment.save();
  console.log(chalk.green("[nedb-environment] [update] " + envId.environmentId + ": " + JSON.stringify(data)));
  return dataAdjust(environment);
};

exports.deleteEnvironment = async environmentId => {
  return await Environment.findOneAndDelete({ environmentId: environmentId });
};

exports.deleteEnvironmentById = async data => {
  console.log(chalk.green("[nedb-environment] [delete] " + data.environmentId + ": deleted"));
  return await Environment.findOneAndDelete({ environmentId: data.environmentId });
};

exports.deleteAllEnvironment = async () => {
  return await Environment.deleteMany({});
};

function dataAdjust(data) {
  return {
    name: data.name,
    environmentId: data.environmentId ? data.environmentId : uuidv4(),
    devices: data.devices
  }
}