"use strict";

const Device = require("../device.model");
//const localClient = require("../../../server-mqtt/src/mqtt/localClient");
const brokerClient = require("../../../server-mqtt/src/mqtt/brokerClient");
const environmentDAO = require("./environment.dao");
var _ = require("lodash");
const chalk = require("chalk");

exports.listDeviceById = async data =>
  await Device.findOne({ _id: data.deviceId });

exports.listDeviceByIeeeAddr = async data =>
  await Device.findOne({ ieeeAddr: data.ieeeAddr });

exports.listDeviceByNwkAddr = async data =>
  await Device.findOne({ nwkAddr: data.nwkAddr });

exports.listDevicesByEnvironment = async data =>
  await Device.find({ environment: data.environmentId });

exports.listDevices = async data => {
  let devices = await Device.find();
  return devices;
};

exports.listDevicesMqtt = async data => {
  let devices = await Device.find();
  var devs = devices.map(device => dataAdjust(device));
  return devs;
};

exports.createDevice = async data => {
  let testDevice = await Device.findOne({ ieeeAddr: data.ieeeAddr });
  if (!testDevice) {
    console.log(chalk.blue("[nedb-device] [create] new device"));

    data.name = data.modelId ? data.modelId : "unknown";
    let device = await Device.create(data);
    await device.save();

    sendMqtt(dataAdjust(device), "device", "add");
    return device;
  } else {
    console.log(chalk.blue("[nedb-device] [create] device already exists"));

    testDevice.nwkAddr = data.nwkAddr;
    let res = await Device.findOneAndUpdate(
      { ieeeAddr: testDevice.ieeeAddr },
      { nwkAddr: testDevice.nwkAddr, lastUpdate: Date.now() }
    );

    sendMqtt(dataAdjust(res), "device/" + res.ieeeAddr + "/status", "edit");
    return res;
  }
};

exports.updateDevice = async (param, data) => {
  try {
    // const currentDevice = await Device.findOne({ ieeeAddr: param.ieeeAddr });
    const device = await Device.findOneAndUpdate(
      { ieeeAddr: param.ieeeAddr },
      data
    );
    // if (currentDevice.environment.environmentId != device.environment.environmentId) {
    //   changeEnvironment(device);
    // }
    //console.log(chalk.blue("[nedb-device] " + device.name));
    if (device) {
      device.lastUpdate = Date.now();
      device.save();
      /*
      console.log(
        chalk.green(
          "[nedb-device] [update] " +
            param.ieeeAddr +
            ": " +
            JSON.stringify(data)
        )
      );*/
      return dataAdjust(device);
    } else {
      console.log(chalk.red("[nedb-device] [update] device not added yet"));
      return {};
    }
  } catch (err) {
    console.log(chalk.red("[nedb-device] [update] " + err));
    return err;
  }
};

exports.deleteDevice = async param => {
  return await Device.findOneAndDelete({ _id: param.deviceId });
};

exports.deleteDeviceByIeeeAddr = async data => {
  let res = await Device.findOneAndDelete({ ieeeAddr: data.ieeeAddr });
  console.log(
    chalk.green(
      "[nedb-device] [delete] " + data.ieeeAddr + ": " + res + ", deleted"
    )
  );
  return res;
};

exports.deleteAllDevices = async () => {
  return await Device.deleteMany({});
};

exports.addNewBlockedUser = async (param, data) => {
  let device = await Device.findOne({ _id: param.deviceId });
  device.blockedUsersList.push(data);
  device.lastUpdate = Date.now();
  await device.save();
  return device;
};

exports.removeBlockedUser = async (param, data) => {
  let device = await Device.findOne({ _id: param.deviceId });
  let dado = data;
  let index = _.pullAllBy(device.blockedUsersList, [data], "blockedUserID");
  device.lastUpdate = Date.now();
  await device.save();
  return device;
};

async function changeEnvironment(device) {
  let dev = device.toJSON();
  let environments = await environmentDAO.getEnvironmentWithDevice(dev);
  console.log("CHANGE ENV: ", environments);
  // await environments.forEach(async environment => {
  //   let updatedDevices = await _.remove(environment.devices, function(o) {
  //     return o.ieeeAddr != dev.ieeeAddr;
  //   });
  //   if (environment.environmentId == dev.environment.environmentId) {
  //     console.log("ENTROU")
  //     updatedDevices.push({
  //       name: dev.name,
  //       devId: dev.devId,
  //       ieeeAddr: dev.ieeeAddr
  //     });
  //   }
  //   updatedDevices = {
  //     devices: updatedDevices
  //   };
  //   await environmentDAO.updateEnvironment(environment, updatedDevices);
  // });
}

async function sendMqtt(data, endTopic, operation) {
  var result = await {
    topic: endTopic,
    operation: operation,
    data: data
  };
  brokerClient.publish(result);
}

function dataAdjust(data) {
  return {
    name: data.name ? data.name.trim() : "unknown",
    ieeeAddr: data.ieeeAddr,
    epList: data.epList,
    nwkAddr: data.nwkAddr.toString(),
    profId: data.profId,
    devId: data.devId,
    modelId: data.modelId ? data.modelId.trim() : "unknown",
    status: data.status,
    manufId: data.manufId,
    manufName: data.manufName,
    powerSource: data.powerSource,
    type: data.type,
    environment: data.environment,
    clusters: data.clusters,
    blocked: data.blocked,
    isActive: data.isActive,
    inClusterList: data.inClusterList,
    outClusterList: data.outClusterList
  };
}

module.exports.dataAdjust = dataAdjust